/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.BooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import me.shedaniel.architectury.registry.Registries;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ObservationTask
extends BooleanTask {
    public long timer = 0L;
    public int type = 1;
    public String observeId = "minecraft:dirt";

    public ObservationTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.OBSERVATION;
    }

    private String toStringO() {
        if (this.type <= 0 || this.observeId.isEmpty()) {
            return "";
        }
        if (this.type == 1) {
            return "block:" + this.observeId;
        }
        if (this.type == 2) {
            return "block_entity:" + this.observeId;
        }
        if (this.type == 3) {
            return "block_entity_class:" + this.observeId;
        }
        return "";
    }

    private void fromStringO(String string) {
        this.type = 0;
        this.observeId = "";
        try {
            if (string.startsWith("block:")) {
                this.observeId = string.substring(6);
                this.type = 1;
            } else if (string.startsWith("block_entity:")) {
                this.observeId = string.substring(6);
                this.type = 1;
            } else if (string.startsWith("block_entity_class:")) {
                this.observeId = string.substring(6);
                this.type = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74772_a("timer", this.timer);
        nbt.func_74778_a("observe", this.toStringO());
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.timer = nbt.func_74763_f("timer");
        this.fromStringO(nbt.func_74779_i("observe"));
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_179254_b(this.timer);
        buffer.func_211400_a(this.toStringO(), Short.MAX_VALUE);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.timer = buffer.func_179260_f();
        this.fromStringO(buffer.func_150789_c(Short.MAX_VALUE));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("timer", this.timer, v -> {
            this.timer = v;
        }, 0L, 0L, 1200L);
        config.addString("observe", this.toStringO(), this::fromStringO, "block:minecraft:dirt");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
    }

    @Override
    public boolean canSubmit(TeamData teamData, ServerPlayerEntity player) {
        return true;
    }

    @Override
    public boolean checkOnLogin() {
        return false;
    }

    public boolean observe(PlayerEntity player, RayTraceResult result) {
        if (this.observeId.isEmpty() || this.type <= 0) {
            return false;
        }
        if (result instanceof BlockRayTraceResult) {
            if (this.type == 1) {
                return this.observeId.equals(String.valueOf(Registries.getId((Object)player.field_70170_p.func_180495_p(((BlockRayTraceResult)result).func_216350_a()).func_177230_c(), (RegistryKey)Registry.field_239711_l_)));
            }
            if (this.type == 2) {
                TileEntity blockEntity = player.field_70170_p.func_175625_s(((BlockRayTraceResult)result).func_216350_a());
                return blockEntity != null && this.observeId.equals(String.valueOf(Registries.getId((Object)blockEntity.func_200662_C(), (RegistryKey)Registry.field_239667_E_)));
            }
            if (this.type == 3) {
                TileEntity blockEntity = player.field_70170_p.func_175625_s(((BlockRayTraceResult)result).func_216350_a());
                return blockEntity != null && this.observeId.equals(blockEntity.getClass().getName());
            }
        }
        return false;
    }
}

